/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.history;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.rest.history.APIActivityRecord;
import org.apache.guacamole.rest.history.APISortPredicate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class ActivityRecordSetResource<InternalRecordType extends ActivityRecord, ExternalRecordType extends APIActivityRecord> {
    private static final int MAXIMUM_HISTORY_SIZE = 1000;
    private ActivityRecordSet<InternalRecordType> history;

    public ActivityRecordSetResource(ActivityRecordSet<InternalRecordType> history) {
        this.history = history;
    }

    protected abstract ExternalRecordType toExternalRecord(InternalRecordType var1);

    @GET
    public List<ExternalRecordType> getRecords(@QueryParam(value="contains") List<String> requiredContents, @QueryParam(value="order") List<APISortPredicate> sortPredicates) throws GuacamoleException {
        for (String required : requiredContents) {
            if (required.isEmpty()) continue;
            this.history = this.history.contains(required);
        }
        for (APISortPredicate predicate : sortPredicates) {
            this.history = this.history.sort(predicate.getProperty(), predicate.isDescending());
        }
        this.history = this.history.limit(1000);
        ArrayList<APIActivityRecord> apiRecords = new ArrayList<APIActivityRecord>();
        for (ActivityRecord record : this.history.asCollection()) {
            apiRecords.add(this.toExternalRecord(record));
        }
        return apiRecords;
    }
}

